using System;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Ocl.Support;

namespace CustomOclOperations
{
	public class StandardDeviationOclOp: OclOperationBase
	{
		// Here is the mathematical calculation of standard deviation
		public static double GetStandardDeviation(double[] num)
		{
			double Sum = 0.0, SumOfSqrs = 0.0;
			for (int i = 0; i < num.Length; i++)
			{
				Sum += num[i];
				SumOfSqrs += Math.Pow(num[i], 2);
			}
			double topSum = (num.Length * SumOfSqrs) - (Math.Pow(Sum, 2));
			double n = (double)num.Length;
			return Math.Sqrt(topSum / (n * (n - 1)));
		}
		public override void Evaluate(IOclOperationParameters parameters)
		{
			// first extract the value of the 0th parameter
			IElementCollection collection = Support.GetAsList(parameters.Values[0]);
			double res = 0;
			if (collection.Count > 1)
			{
				// copy the values into an array of doubles
				double[] arr = new double[collection.Count];
				for (int i = 0; i < collection.Count; i++)
				{
					arr[i] = (double)collection[i].AsObject;
				}
				// calculate the result
				res = GetStandardDeviation(arr);
			}
			// store the result in the result parameter
			Support.MakeNewNumeric(parameters.Result, res);
		}
		protected override void Init()
		{
			// the name of the operation is standardDeviation
			// there is only one parameter (the 0th parameter, and its type is a list of numbers
			// the result is a real number.
			InternalInit("standardDeviation", new IOclType[]{Support.NumericListType}, Support.RealType);
		}
	}
}
